/********************************************************************************************************
* Donohue and Wolfers (2006) 
* Table 8
* Estimating Net Lives Saved per Execution: Exploring the Validity of the Dezhbakhsh, Rubin, 
* and Shepherd (DRS) Instrumental Variables (1977-1996)
********************************************************************************************************/
pause on
set more off
cd "..."
clear
program drop _all
set mem 800m
set mat 500

program define setlags
* Program creates the variables required for models 4-6
	drop if YEAR==76
	drop if COUNTY==51570 & YEAR==80 & MURDO1==0
 	tsset COUNTY YEAR
	* But I'll butcher it slightly
 	egen yr=rank(YEAR), by(COUNTY)
 	tsset COUNTY yr
 	sort COUNTY yr
	* Prepare Table 5 variables
	for Q in any PAMURC PEXECF PEXECP PEXECA PSENTP PSENTF PSENTA: gen Qb=Q
	replace PAMURCb=. if MURDO1==0 & AMUR~=.
	for Q in any PAMURC PEXECF PEXECP PEXECA: for Z in num 1/6: gen QZb=lZ.Qb if Qb==.
	for Z in num 1/6: replace PEXECFZb=0 if PEXECFZb==. & YEAR-Z<77
	for Z in num 1/6: replace PAMURCb=PAMURCZb if PAMURCb==. & MURDO1==0 & AMUR~=.
	for Z in num 1/6: for Q in any PEXECF PEXECP PEXECA: replace Qb=QZb if Qb==.
end

program define firststage
	* First Stage, Table 4
	areg  PAMURC POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC], absorb(COUNTY) 
	predict double PAMURCP2 , xbd

	areg  PSENTP POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC], absorb(COUNTY) 
	predict double PSENTPP2 , xbd
	areg  PSENTF POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC], absorb(COUNTY) 
	predict double PSENTFP2 , xbd
	areg  PSENTA POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC] if (FIPSSTAT==4 & (YEAR==82 | YEAR==83))~=1, absorb(COUNTY) 
	predict PSENTAP2, xbd

	areg  PEXECP POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC], absorb(COUNTY) 
	predict double PEXECPP2, xbd
	areg  PEXECF POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC], absorb(COUNTY) 
	predict double PEXECFP2, xbd
	areg  PEXECA POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC], absorb(COUNTY) 
	predict double PEXECAP2, xbd

	* First stage, Table 5
	areg  PAMURCb POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC], absorb(COUNTY) 
	predict double PAMURCP2b , xbd

	areg  PSENTPb POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC], absorb(COUNTY) 
	predict double PSENTPP2b , xbd
	areg  PSENTFb POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC], absorb(COUNTY) 
	predict double PSENTFP2b , xbd
	areg  PSENTAb POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC] if (FIPSSTAT==4 & (YEAR==82 | YEAR==83))~=1, absorb(COUNTY) 
	predict PSENTAP2b, xbd

	areg  PEXECPb POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC], absorb(COUNTY) 
	predict double PEXECPP2b, xbd
	areg  PEXECFb POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC], absorb(COUNTY) 
	predict double PEXECFP2b, xbd
	areg  PEXECAb POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC], absorb(COUNTY) 
	predict double PEXECAP2b, xbd
end

program define secondstage
	* Table 4 of DRS
	areg RATMUR RATAGA RATROB PAMURCP2 PSENTPP2 PEXECPP2 PP1019 PP2029 PPB PPN PPM NRARATE RPCPI RPCIM RPCUI DENSITYM  IYEAR* [aweight=POPC], absorb(COUNTY)  
	lincom -_b[PEXECPP2]*((2293)/38)/(320/38)-1
	lincom -(_b[PEXECPP2]+1.96*_se[PEXECPP2])*((2293)/38)/(320/38)-1
	lincom -(_b[PEXECPP2]-1.96*_se[PEXECPP2])*((2293)/38)/(320/38)-1
	areg RATMUR RATAGA RATROB PAMURCP2 PSENTFP2 PEXECFP2 PP1019 PP2029 PPB PPN PPM NRARATE RPCPI RPCIM RPCUI DENSITYM  IYEAR* [aweight=POPC], absorb(COUNTY)  
	lincom -_b[PEXECFP2]*((2293)/38)/(320/38)-1
	lincom -(_b[PEXECFP2]+1.96*_se[PEXECFP2])*((2293)/38)/(320/38)-1
	lincom -(_b[PEXECFP2]-1.96*_se[PEXECFP2])*((2293)/38)/(320/38)-1
	areg RATMUR RATAGA RATROB PAMURCP2 PSENTAP2 PEXECAP2 PP1019 PP2029 PPB PPN PPM NRARATE RPCPI RPCIM RPCUI DENSITYM  IYEAR* [aweight=POPC], absorb(COUNTY)  
	lincom -_b[PEXECAP2]*((2293)/38)/(320/38)-1
	lincom -(_b[PEXECAP2]+1.96*_se[PEXECAP2])*((2293)/38)/(320/38)-1
	lincom -(_b[PEXECAP2]-1.96*_se[PEXECAP2])*((2293)/38)/(320/38)-1

	* Table 5 of DRS
	areg RATMUR RATAGA RATROB PAMURCP2b PSENTPP2b PEXECPP2b PP1019 PP2029 PPB PPN PPM NRARATE RPCPI RPCIM RPCUI DENSITYM  IYEAR* [aweight=POPC], absorb(COUNTY)  
	lincom -_b[PEXECPP2b]*((2293)/38)/(320/38)-1
	lincom -(_b[PEXECPP2b]+1.96*_se[PEXECPP2b])*((2293)/38)/(320/38)-1
	lincom -(_b[PEXECPP2b]-1.96*_se[PEXECPP2b])*((2293)/38)/(320/38)-1
	areg RATMUR RATAGA RATROB PAMURCP2b PSENTFP2b PEXECFP2b PP1019 PP2029 PPB PPN PPM NRARATE RPCPI RPCIM RPCUI DENSITYM  IYEAR* [aweight=POPC], absorb(COUNTY)  
	lincom -_b[PEXECFP2b]*((2293)/38)/(320/38)-1
	lincom -(_b[PEXECFP2b]+1.96*_se[PEXECFP2b])*((2293)/38)/(320/38)-1
	lincom -(_b[PEXECFP2b]-1.96*_se[PEXECFP2b])*((2293)/38)/(320/38)-1
	areg RATMUR RATAGA RATROB PAMURCP2b PSENTAP2b PEXECAP2b PP1019 PP2029 PPB PPN PPM NRARATE RPCPI RPCIM RPCUI DENSITYM  IYEAR* [aweight=POPC], absorb(COUNTY)  
	lincom -_b[PEXECAP2b]*((2293)/38)/(320/38)-1
	lincom -(_b[PEXECAP2b]+1.96*_se[PEXECAP2b])*((2293)/38)/(320/38)-1
	lincom -(_b[PEXECAP2b]-1.96*_se[PEXECAP2b])*((2293)/38)/(320/38)-1
end

*Panel A
use CPcounty5_send.dta, clear
setlags
firststage
secondstage

*Panel B
use CPcounty5_send.dta, clear

gen fips=FIPSST
* cd ..
do "fips to st.do"
gen year=YEAR+1900
gen legal=1
replace legal=0 if st=="MI" & year>=1846
replace legal=0 if st=="RI" & year>=1852
replace legal=0 if st=="WI" & year>=1853
replace legal=0 if st=="IA" & year>=1872 & year<1878
replace legal=0 if st=="ME" & year>=1876 & year<1883
replace legal=0 if st=="ME" & year>=1887
replace legal=0 if st=="CO" & year>=1897 & year<1901
replace legal=0 if st=="KS" & year>=1907 & year<1935
replace legal=0 if st=="MN" & year>=1911
replace legal=0 if st=="WA" & year>=1913 & year<1919
replace legal=0 if st=="OR" & year>=1914 & year<1920
replace legal=0 if st=="ND" & year>=1973
replace legal=0 if st=="SD" & year>=1915 & year<1939
replace legal=0 if st=="TN" & year>=1915 & year<1916
replace legal=0 if st=="AZ" & year>=1916 & year<1918
replace legal=0 if st=="MO" & year>=1917 & year<1919
replace legal=0 if st=="AK" & year>=1957
replace legal=0 if st=="HI" & year>=1957
replace legal=0 if st=="DE" & year>=1958 & year<1961
replace legal=0 if st=="OR" & year>=1964
replace legal=0 if st=="IA" & year>=1965
replace legal=0 if st=="WV" & year>=1965
replace legal=0 if st=="VT" & year>=1965
replace legal=0 if st=="NY" & year>=1965
replace legal=0 if st=="NM" & year>=1969
replace legal=0 if st=="NH" & year>=1972 /* Court decision */
replace legal=0 if st=="CA" & year>=1972 /* Court decision */
replace legal=0 if year>=1972
replace legal=1 if st=="RI" & year>=1977 & year<1984
replace legal=1 if st=="MA" & year>=1982 & year<1984
replace legal=1 if st=="AL" & year>=1976
replace legal=1 if st=="AZ" & year>=1973
replace legal=1 if st=="AR" & year>=1973
replace legal=1 if st=="CA" & year>=1977
replace legal=1 if st=="CO" & year>=1975
replace legal=1 if st=="CT" & year>=1973
replace legal=1 if st=="DE" & year>=1974
replace legal=1 if st=="FL" & year>=1972
replace legal=1 if st=="GA" & year>=1973
replace legal=1 if st=="ID" & year>=1973
replace legal=1 if st=="IL" & year>=1974
replace legal=1 if st=="IN" & year>=1973
replace legal=1 if st=="KS" & year>=1994
replace legal=1 if st=="KY" & year>=1975
replace legal=1 if st=="LA" & year>=1973
replace legal=1 if st=="MD" & year>=1975
replace legal=1 if st=="MS" & year>=1974
replace legal=1 if st=="MO" & year>=1975
replace legal=1 if st=="MT" & year>=1974
replace legal=1 if st=="NE" & year>=1973
replace legal=1 if st=="NV" & year>=1973
replace legal=1 if st=="NH" & year>=1991
replace legal=1 if st=="NJ" & year>=1982
replace legal=1 if st=="NM" & year>=1979
replace legal=1 if st=="NY" & year>=1995
replace legal=1 if st=="NC" & year>=1977
replace legal=1 if st=="OH" & year>=1974
replace legal=1 if st=="OK" & year>=1973
replace legal=1 if st=="OR" & year>=1978
replace legal=1 if st=="PA" & year>=1974
replace legal=1 if st=="SC" & year>=1974
replace legal=1 if st=="SD" & year>=1979
replace legal=1 if st=="TN" & year>=1974
replace legal=1 if st=="TX" & year>=1974
replace legal=1 if st=="UT" & year>=1973
replace legal=1 if st=="VA" & year>=1975
replace legal=1 if st=="WA" & year>=1975
replace legal=1 if st=="WY" & year>=1977
replace legal=0 if year>=1972 & year<1976

setlags
firststage
preserve
replace RATMUR=. if legal==1
secondstage

*Panel C
use CPcounty5_send.dta, clear
setlags
firststage

for var vote1-vote6: gen IYEAR_X=X
secondstage
drop IYEAR_v*  

*Panel D
use CPcounty5_send.dta, clear
setlags
firststage
for var PRISADM JLEXPD POLEXPD: gen IYEAR_X=X
secondstage
drop IYEAR_PRISADM IYEAR_JLEXPD IYEAR_POLEXPD
